package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisStreamsInputUpdate(resourceARNUpdate: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate = {
    import KinesisStreamsInputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate
      .builder()
      .resourceARNUpdate(
        ResourceARN.unwrap(resourceARNUpdate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputUpdate
      .wrap(buildAwsValue())
}
object KinesisStreamsInputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputUpdate =
      zio.aws.kinesisanalyticsv2.model
        .KinesisStreamsInputUpdate(resourceARNUpdate)
    def resourceARNUpdate: ResourceARN
    def getResourceARNUpdate: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputUpdate.ReadOnly {
    override val resourceARNUpdate: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARNUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputUpdate
  ): zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputUpdate.ReadOnly =
    new Wrapper(impl)
}
