package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomArtifactConfigurationDescription(
    artifactType: Optional[zio.aws.kinesisanalyticsv2.model.ArtifactType] =
      Optional.Absent,
    s3ContentLocationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation
    ] = Optional.Absent,
    mavenReferenceDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.MavenReference
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription = {
    import CustomArtifactConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
      .builder()
      .optionallyWith(artifactType.map(value => value.unwrap))(_.artifactType)
      .optionallyWith(
        s3ContentLocationDescription.map(value => value.buildAwsValue())
      )(_.s3ContentLocationDescription)
      .optionallyWith(
        mavenReferenceDescription.map(value => value.buildAwsValue())
      )(_.mavenReferenceDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
      .wrap(buildAwsValue())
}
object CustomArtifactConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription(
        artifactType.map(value => value),
        s3ContentLocationDescription.map(value => value.asEditable),
        mavenReferenceDescription.map(value => value.asEditable)
      )
    def artifactType: Optional[zio.aws.kinesisanalyticsv2.model.ArtifactType]
    def s3ContentLocationDescription
        : Optional[zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly]
    def mavenReferenceDescription
        : Optional[zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly]
    def getArtifactType
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.ArtifactType] =
      AwsError.unwrapOptionField("artifactType", artifactType)
    def getS3ContentLocationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "s3ContentLocationDescription",
      s3ContentLocationDescription
    )
    def getMavenReferenceDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly
    ] = AwsError.unwrapOptionField(
      "mavenReferenceDescription",
      mavenReferenceDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly {
    override val artifactType
        : Optional[zio.aws.kinesisanalyticsv2.model.ArtifactType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactType())
        .map(value => zio.aws.kinesisanalyticsv2.model.ArtifactType.wrap(value))
    override val s3ContentLocationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ContentLocationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.S3ContentLocation.wrap(value)
      )
    override val mavenReferenceDescription
        : Optional[zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mavenReferenceDescription())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.MavenReference.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.CustomArtifactConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
