package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RunConfiguration(
    flinkRunConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration
    ] = Optional.Absent,
    sqlRunConfigurations: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration]
    ] = Optional.Absent,
    applicationRestoreConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfiguration = {
    import RunConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfiguration
      .builder()
      .optionallyWith(
        flinkRunConfiguration.map(value => value.buildAwsValue())
      )(_.flinkRunConfiguration)
      .optionallyWith(
        sqlRunConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sqlRunConfigurations)
      .optionallyWith(
        applicationRestoreConfiguration.map(value => value.buildAwsValue())
      )(_.applicationRestoreConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.RunConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.RunConfiguration.wrap(buildAwsValue())
}
object RunConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.RunConfiguration =
      zio.aws.kinesisanalyticsv2.model.RunConfiguration(
        flinkRunConfiguration.map(value => value.asEditable),
        sqlRunConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationRestoreConfiguration.map(value => value.asEditable)
      )
    def flinkRunConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ]
    def sqlRunConfigurations: Optional[
      List[zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.ReadOnly]
    ]
    def applicationRestoreConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ]
    def getFlinkRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("flinkRunConfiguration", flinkRunConfiguration)
    def getSqlRunConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("sqlRunConfigurations", sqlRunConfigurations)
    def getApplicationRestoreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationRestoreConfiguration",
      applicationRestoreConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.RunConfiguration.ReadOnly {
    override val flinkRunConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.flinkRunConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.wrap(value)
      )
    override val sqlRunConfigurations: Optional[
      List[zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqlRunConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.wrap(item)
        }.toList
      )
    override val applicationRestoreConfiguration: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationRestoreConfiguration())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RunConfiguration
  ): zio.aws.kinesisanalyticsv2.model.RunConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
