package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ZeppelinMonitoringConfiguration(
    logLevel: zio.aws.kinesisanalyticsv2.model.LogLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration = {
    import ZeppelinMonitoringConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration
      .builder()
      .logLevel(logLevel.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration
      .wrap(buildAwsValue())
}
object ZeppelinMonitoringConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration =
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration(logLevel)
    def logLevel: zio.aws.kinesisanalyticsv2.model.LogLevel
    def getLogLevel
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.LogLevel] =
      ZIO.succeed(logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration.ReadOnly {
    override val logLevel: zio.aws.kinesisanalyticsv2.model.LogLevel =
      zio.aws.kinesisanalyticsv2.model.LogLevel.wrap(impl.logLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration
  ): zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfiguration.ReadOnly =
    new Wrapper(impl)
}
