package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ApplicationName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateApplicationMaintenanceConfigurationRequest(
    applicationName: ApplicationName,
    applicationMaintenanceConfigurationUpdate: zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest = {
    import UpdateApplicationMaintenanceConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .applicationMaintenanceConfigurationUpdate(
        applicationMaintenanceConfigurationUpdate.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationMaintenanceConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest =
      zio.aws.kinesisanalyticsv2.model
        .UpdateApplicationMaintenanceConfigurationRequest(
          applicationName,
          applicationMaintenanceConfigurationUpdate.asEditable
        )
    def applicationName: ApplicationName
    def applicationMaintenanceConfigurationUpdate
        : zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationUpdate.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationMaintenanceConfigurationUpdate: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationUpdate.ReadOnly
    ] = ZIO.succeed(applicationMaintenanceConfigurationUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationMaintenanceConfigurationUpdate
        : zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationUpdate.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationUpdate
        .wrap(impl.applicationMaintenanceConfigurationUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest
  ): zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
