package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ZeppelinApplicationConfigurationUpdate(
    monitoringConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate
    ] = Optional.Absent,
    catalogConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate
    ] = Optional.Absent,
    deployAsApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
    ] = Optional.Absent,
    customArtifactsConfigurationUpdate: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate = {
    import ZeppelinApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        monitoringConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.monitoringConfigurationUpdate)
      .optionallyWith(
        catalogConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.catalogConfigurationUpdate)
      .optionallyWith(
        deployAsApplicationConfigurationUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.deployAsApplicationConfigurationUpdate)
      .optionallyWith(
        customArtifactsConfigurationUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customArtifactsConfigurationUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object ZeppelinApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate(
        monitoringConfigurationUpdate.map(value => value.asEditable),
        catalogConfigurationUpdate.map(value => value.asEditable),
        deployAsApplicationConfigurationUpdate.map(value => value.asEditable),
        customArtifactsConfigurationUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitoringConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate.ReadOnly
    ]
    def catalogConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.ReadOnly
    ]
    def deployAsApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly
    ]
    def customArtifactsConfigurationUpdate: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]]
    def getMonitoringConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfigurationUpdate",
      monitoringConfigurationUpdate
    )
    def getCatalogConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "catalogConfigurationUpdate",
      catalogConfigurationUpdate
    )
    def getDeployAsApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deployAsApplicationConfigurationUpdate",
      deployAsApplicationConfigurationUpdate
    )
    def getCustomArtifactsConfigurationUpdate: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customArtifactsConfigurationUpdate",
      customArtifactsConfigurationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly {
    override val monitoringConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate
          .wrap(value)
      )
    override val catalogConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.catalogConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.wrap(value)
      )
    override val deployAsApplicationConfigurationUpdate: Optional[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deployAsApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
          .wrap(value)
      )
    override val customArtifactsConfigurationUpdate: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.customArtifactsConfigurationUpdate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
