package zio.aws.kinesisanalyticsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesisanalyticsv2.model.primitives.{
  BooleanObject,
  ParallelismPerKPU,
  Parallelism
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ParallelismConfigurationDescription(
    configurationType: Optional[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = Optional.Absent,
    parallelism: Optional[Parallelism] = Optional.Absent,
    parallelismPerKPU: Optional[ParallelismPerKPU] = Optional.Absent,
    currentParallelism: Optional[Parallelism] = Optional.Absent,
    autoScalingEnabled: Optional[BooleanObject] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription = {
    import ParallelismConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
      .builder()
      .optionallyWith(configurationType.map(value => value.unwrap))(
        _.configurationType
      )
      .optionallyWith(
        parallelism.map(value => Parallelism.unwrap(value): Integer)
      )(_.parallelism)
      .optionallyWith(
        parallelismPerKPU.map(value => ParallelismPerKPU.unwrap(value): Integer)
      )(_.parallelismPerKPU)
      .optionallyWith(
        currentParallelism.map(value => Parallelism.unwrap(value): Integer)
      )(_.currentParallelism)
      .optionallyWith(
        autoScalingEnabled.map(value => value: java.lang.Boolean)
      )(_.autoScalingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription
      .wrap(buildAwsValue())
}
object ParallelismConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription(
        configurationType.map(value => value),
        parallelism.map(value => value),
        parallelismPerKPU.map(value => value),
        currentParallelism.map(value => value),
        autoScalingEnabled.map(value => value)
      )
    def configurationType
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def parallelism: Optional[Parallelism]
    def parallelismPerKPU: Optional[ParallelismPerKPU]
    def currentParallelism: Optional[Parallelism]
    def autoScalingEnabled: Optional[BooleanObject]
    def getConfigurationType: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField("configurationType", configurationType)
    def getParallelism: ZIO[Any, AwsError, Parallelism] =
      AwsError.unwrapOptionField("parallelism", parallelism)
    def getParallelismPerKPU: ZIO[Any, AwsError, ParallelismPerKPU] =
      AwsError.unwrapOptionField("parallelismPerKPU", parallelismPerKPU)
    def getCurrentParallelism: ZIO[Any, AwsError, Parallelism] =
      AwsError.unwrapOptionField("currentParallelism", currentParallelism)
    def getAutoScalingEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("autoScalingEnabled", autoScalingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly {
    override val configurationType
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationType())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
        )
    override val parallelism: Optional[Parallelism] = zio.aws.core.internal
      .optionalFromNullable(impl.parallelism())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.Parallelism(value)
      )
    override val parallelismPerKPU: Optional[ParallelismPerKPU] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parallelismPerKPU())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.ParallelismPerKPU(value)
        )
    override val currentParallelism: Optional[Parallelism] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentParallelism())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.Parallelism(value)
        )
    override val autoScalingEnabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScalingEnabled())
        .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ParallelismConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
