package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters._
sealed trait MetricsLevel {
  def unwrap
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel
}
object MetricsLevel {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel
  ): zio.aws.kinesisanalyticsv2.model.MetricsLevel = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.APPLICATION =>
      val r = APPLICATION
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.TASK =>
      val r = TASK
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.OPERATOR =>
      val r = OPERATOR
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.PARALLELISM =>
      val r = PARALLELISM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.MetricsLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object APPLICATION
      extends zio.aws.kinesisanalyticsv2.model.MetricsLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.APPLICATION
  }
  case object TASK extends zio.aws.kinesisanalyticsv2.model.MetricsLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.TASK
  }
  case object OPERATOR extends zio.aws.kinesisanalyticsv2.model.MetricsLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.OPERATOR
  }
  case object PARALLELISM
      extends zio.aws.kinesisanalyticsv2.model.MetricsLevel {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.MetricsLevel.PARALLELISM
  }
}
