package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisFirehoseInputUpdate(resourceARNUpdate: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate = {
    import KinesisFirehoseInputUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate
      .builder()
      .resourceARNUpdate(
        ResourceARN.unwrap(resourceARNUpdate): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate
      .wrap(buildAwsValue())
}
object KinesisFirehoseInputUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate =
      zio.aws.kinesisanalyticsv2.model
        .KinesisFirehoseInputUpdate(resourceARNUpdate)
    def resourceARNUpdate: ResourceARN
    def getResourceARNUpdate: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARNUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate.ReadOnly {
    override val resourceARNUpdate: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARNUpdate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate
  ): zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInputUpdate.ReadOnly =
    new Wrapper(impl)
}
