package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ConditionalToken,
  Id,
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteApplicationCloudWatchLoggingOptionRequest(
    applicationName: ApplicationName,
    currentApplicationVersionId: Optional[ApplicationVersionId] =
      Optional.Absent,
    cloudWatchLoggingOptionId: Id,
    conditionalToken: Optional[ConditionalToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest = {
    import DeleteApplicationCloudWatchLoggingOptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        currentApplicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.currentApplicationVersionId)
      .cloudWatchLoggingOptionId(
        Id.unwrap(cloudWatchLoggingOptionId): java.lang.String
      )
      .optionallyWith(
        conditionalToken.map(value =>
          ConditionalToken.unwrap(value): java.lang.String
        )
      )(_.conditionalToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest
      .wrap(buildAwsValue())
}
object DeleteApplicationCloudWatchLoggingOptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest =
      zio.aws.kinesisanalyticsv2.model
        .DeleteApplicationCloudWatchLoggingOptionRequest(
          applicationName,
          currentApplicationVersionId.map(value => value),
          cloudWatchLoggingOptionId,
          conditionalToken.map(value => value)
        )
    def applicationName: ApplicationName
    def currentApplicationVersionId: Optional[ApplicationVersionId]
    def cloudWatchLoggingOptionId: Id
    def conditionalToken: Optional[ConditionalToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getCurrentApplicationVersionId
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "currentApplicationVersionId",
      currentApplicationVersionId
    )
    def getCloudWatchLoggingOptionId: ZIO[Any, Nothing, Id] =
      ZIO.succeed(cloudWatchLoggingOptionId)
    def getConditionalToken: ZIO[Any, AwsError, ConditionalToken] =
      AwsError.unwrapOptionField("conditionalToken", conditionalToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val currentApplicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentApplicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val cloudWatchLoggingOptionId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives
        .Id(impl.cloudWatchLoggingOptionId())
    override val conditionalToken: Optional[ConditionalToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionalToken())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionRequest.ReadOnly =
    new Wrapper(impl)
}
