package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CatalogConfiguration(
    glueDataCatalogConfiguration: zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CatalogConfiguration = {
    import CatalogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CatalogConfiguration
      .builder()
      .glueDataCatalogConfiguration(
        glueDataCatalogConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.wrap(buildAwsValue())
}
object CatalogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CatalogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CatalogConfiguration =
      zio.aws.kinesisanalyticsv2.model
        .CatalogConfiguration(glueDataCatalogConfiguration.asEditable)
    def glueDataCatalogConfiguration
        : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration.ReadOnly
    def getGlueDataCatalogConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration.ReadOnly
    ] = ZIO.succeed(glueDataCatalogConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CatalogConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.ReadOnly {
    override val glueDataCatalogConfiguration
        : zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.GlueDataCatalogConfiguration
        .wrap(impl.glueDataCatalogConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CatalogConfiguration
  ): zio.aws.kinesisanalyticsv2.model.CatalogConfiguration.ReadOnly =
    new Wrapper(impl)
}
