package zio.aws.kinesisanalyticsv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationName,
  Timestamp,
  ApplicationVersionId,
  RoleARN,
  ResourceARN,
  ConditionalToken,
  ApplicationDescription
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ApplicationDetail(
    applicationARN: ResourceARN,
    applicationDescription: Optional[ApplicationDescription] = Optional.Absent,
    applicationName: ApplicationName,
    runtimeEnvironment: zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment,
    serviceExecutionRole: Optional[RoleARN] = Optional.Absent,
    applicationStatus: zio.aws.kinesisanalyticsv2.model.ApplicationStatus,
    applicationVersionId: ApplicationVersionId,
    createTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdateTimestamp: Optional[Timestamp] = Optional.Absent,
    applicationConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription
    ] = Optional.Absent,
    cloudWatchLoggingOptionDescriptions: Optional[Iterable[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
    ]] = Optional.Absent,
    applicationMaintenanceConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
    ] = Optional.Absent,
    applicationVersionUpdatedFrom: Optional[ApplicationVersionId] =
      Optional.Absent,
    applicationVersionRolledBackFrom: Optional[ApplicationVersionId] =
      Optional.Absent,
    conditionalToken: Optional[ConditionalToken] = Optional.Absent,
    applicationVersionRolledBackTo: Optional[ApplicationVersionId] =
      Optional.Absent,
    applicationMode: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMode
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationDetail = {
    import ApplicationDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationDetail
      .builder()
      .applicationARN(ResourceARN.unwrap(applicationARN): java.lang.String)
      .optionallyWith(
        applicationDescription.map(value =>
          ApplicationDescription.unwrap(value): java.lang.String
        )
      )(_.applicationDescription)
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .runtimeEnvironment(runtimeEnvironment.unwrap)
      .optionallyWith(
        serviceExecutionRole.map(value =>
          RoleARN.unwrap(value): java.lang.String
        )
      )(_.serviceExecutionRole)
      .applicationStatus(applicationStatus.unwrap)
      .applicationVersionId(
        ApplicationVersionId.unwrap(applicationVersionId): java.lang.Long
      )
      .optionallyWith(
        createTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createTimestamp)
      .optionallyWith(
        lastUpdateTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTimestamp)
      .optionallyWith(
        applicationConfigurationDescription.map(value => value.buildAwsValue())
      )(_.applicationConfigurationDescription)
      .optionallyWith(
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionDescriptions)
      .optionallyWith(
        applicationMaintenanceConfigurationDescription.map(value =>
          value.buildAwsValue()
        )
      )(_.applicationMaintenanceConfigurationDescription)
      .optionallyWith(
        applicationVersionUpdatedFrom.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionUpdatedFrom)
      .optionallyWith(
        applicationVersionRolledBackFrom.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionRolledBackFrom)
      .optionallyWith(
        conditionalToken.map(value =>
          ConditionalToken.unwrap(value): java.lang.String
        )
      )(_.conditionalToken)
      .optionallyWith(
        applicationVersionRolledBackTo.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionRolledBackTo)
      .optionallyWith(applicationMode.map(value => value.unwrap))(
        _.applicationMode
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationDetail.wrap(buildAwsValue())
}
object ApplicationDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ApplicationDetail =
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail(
        applicationARN,
        applicationDescription.map(value => value),
        applicationName,
        runtimeEnvironment,
        serviceExecutionRole.map(value => value),
        applicationStatus,
        applicationVersionId,
        createTimestamp.map(value => value),
        lastUpdateTimestamp.map(value => value),
        applicationConfigurationDescription.map(value => value.asEditable),
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        applicationMaintenanceConfigurationDescription.map(value =>
          value.asEditable
        ),
        applicationVersionUpdatedFrom.map(value => value),
        applicationVersionRolledBackFrom.map(value => value),
        conditionalToken.map(value => value),
        applicationVersionRolledBackTo.map(value => value),
        applicationMode.map(value => value)
      )
    def applicationARN: ResourceARN
    def applicationDescription: Optional[ApplicationDescription]
    def applicationName: ApplicationName
    def runtimeEnvironment: zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
    def serviceExecutionRole: Optional[RoleARN]
    def applicationStatus: zio.aws.kinesisanalyticsv2.model.ApplicationStatus
    def applicationVersionId: ApplicationVersionId
    def createTimestamp: Optional[Timestamp]
    def lastUpdateTimestamp: Optional[Timestamp]
    def applicationConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription.ReadOnly
    ]
    def cloudWatchLoggingOptionDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]]
    def applicationMaintenanceConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly
    ]
    def applicationVersionUpdatedFrom: Optional[ApplicationVersionId]
    def applicationVersionRolledBackFrom: Optional[ApplicationVersionId]
    def conditionalToken: Optional[ConditionalToken]
    def applicationVersionRolledBackTo: Optional[ApplicationVersionId]
    def applicationMode
        : Optional[zio.aws.kinesisanalyticsv2.model.ApplicationMode]
    def getApplicationARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(applicationARN)
    def getApplicationDescription: ZIO[Any, AwsError, ApplicationDescription] =
      AwsError.unwrapOptionField(
        "applicationDescription",
        applicationDescription
      )
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getRuntimeEnvironment: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
    ] = ZIO.succeed(runtimeEnvironment)
    def getServiceExecutionRole: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("serviceExecutionRole", serviceExecutionRole)
    def getApplicationStatus: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationStatus
    ] = ZIO.succeed(applicationStatus)
    def getApplicationVersionId: ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(applicationVersionId)
    def getCreateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createTimestamp", createTimestamp)
    def getLastUpdateTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTimestamp", lastUpdateTimestamp)
    def getApplicationConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationConfigurationDescription",
      applicationConfigurationDescription
    )
    def getCloudWatchLoggingOptionDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionDescriptions",
      cloudWatchLoggingOptionDescriptions
    )
    def getApplicationMaintenanceConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationMaintenanceConfigurationDescription",
      applicationMaintenanceConfigurationDescription
    )
    def getApplicationVersionUpdatedFrom
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "applicationVersionUpdatedFrom",
      applicationVersionUpdatedFrom
    )
    def getApplicationVersionRolledBackFrom
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "applicationVersionRolledBackFrom",
      applicationVersionRolledBackFrom
    )
    def getConditionalToken: ZIO[Any, AwsError, ConditionalToken] =
      AwsError.unwrapOptionField("conditionalToken", conditionalToken)
    def getApplicationVersionRolledBackTo
        : ZIO[Any, AwsError, ApplicationVersionId] = AwsError.unwrapOptionField(
      "applicationVersionRolledBackTo",
      applicationVersionRolledBackTo
    )
    def getApplicationMode
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.ApplicationMode] =
      AwsError.unwrapOptionField("applicationMode", applicationMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationDetail
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly {
    override val applicationARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.applicationARN())
    override val applicationDescription: Optional[ApplicationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationDescription())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationDescription(value)
        )
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val runtimeEnvironment
        : zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment =
      zio.aws.kinesisanalyticsv2.model.RuntimeEnvironment
        .wrap(impl.runtimeEnvironment())
    override val serviceExecutionRole: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceExecutionRole())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value))
    override val applicationStatus
        : zio.aws.kinesisanalyticsv2.model.ApplicationStatus =
      zio.aws.kinesisanalyticsv2.model.ApplicationStatus
        .wrap(impl.applicationStatus())
    override val applicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.applicationVersionId())
    override val createTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createTimestamp())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.Timestamp(value)
      )
    override val lastUpdateTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdateTimestamp())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.Timestamp(value)
        )
    override val applicationConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationDescription
          .wrap(value)
      )
    override val cloudWatchLoggingOptionDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptionDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
            .wrap(item)
        }.toList
      )
    override val applicationMaintenanceConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(
        impl.applicationMaintenanceConfigurationDescription()
      )
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
          .wrap(value)
      )
    override val applicationVersionUpdatedFrom: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationVersionUpdatedFrom())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val applicationVersionRolledBackFrom
        : Optional[ApplicationVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationVersionRolledBackFrom())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
    override val conditionalToken: Optional[ConditionalToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.conditionalToken())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.ConditionalToken(value)
        )
    override val applicationVersionRolledBackTo
        : Optional[ApplicationVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationVersionRolledBackTo())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationVersionId(value)
      )
    override val applicationMode
        : Optional[zio.aws.kinesisanalyticsv2.model.ApplicationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationMode())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ApplicationMode.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationDetail
  ): zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly = new Wrapper(
    impl
  )
}
