package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RollbackApplicationResponse(
    applicationDetail: zio.aws.kinesisanalyticsv2.model.ApplicationDetail
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse = {
    import RollbackApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse
      .builder()
      .applicationDetail(applicationDetail.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse
      .wrap(buildAwsValue())
}
object RollbackApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse =
      zio.aws.kinesisanalyticsv2.model
        .RollbackApplicationResponse(applicationDetail.asEditable)
    def applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    def getApplicationDetail: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    ] = ZIO.succeed(applicationDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly {
    override val applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail
        .wrap(impl.applicationDetail())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RollbackApplicationResponse
  ): zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
