package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  MinPauseBetweenCheckpoints,
  CheckpointInterval,
  BooleanObject
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CheckpointConfigurationDescription(
    configurationType: Optional[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = Optional.Absent,
    checkpointingEnabled: Optional[BooleanObject] = Optional.Absent,
    checkpointInterval: Optional[CheckpointInterval] = Optional.Absent,
    minPauseBetweenCheckpoints: Optional[MinPauseBetweenCheckpoints] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription = {
    import CheckpointConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
      .builder()
      .optionallyWith(configurationType.map(value => value.unwrap))(
        _.configurationType
      )
      .optionallyWith(
        checkpointingEnabled.map(value => value: java.lang.Boolean)
      )(_.checkpointingEnabled)
      .optionallyWith(
        checkpointInterval.map(value =>
          CheckpointInterval.unwrap(value): java.lang.Long
        )
      )(_.checkpointInterval)
      .optionallyWith(
        minPauseBetweenCheckpoints.map(value =>
          MinPauseBetweenCheckpoints.unwrap(value): java.lang.Long
        )
      )(_.minPauseBetweenCheckpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription
      .wrap(buildAwsValue())
}
object CheckpointConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription(
        configurationType.map(value => value),
        checkpointingEnabled.map(value => value),
        checkpointInterval.map(value => value),
        minPauseBetweenCheckpoints.map(value => value)
      )
    def configurationType
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def checkpointingEnabled: Optional[BooleanObject]
    def checkpointInterval: Optional[CheckpointInterval]
    def minPauseBetweenCheckpoints: Optional[MinPauseBetweenCheckpoints]
    def getConfigurationType: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField("configurationType", configurationType)
    def getCheckpointingEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("checkpointingEnabled", checkpointingEnabled)
    def getCheckpointInterval: ZIO[Any, AwsError, CheckpointInterval] =
      AwsError.unwrapOptionField("checkpointInterval", checkpointInterval)
    def getMinPauseBetweenCheckpoints
        : ZIO[Any, AwsError, MinPauseBetweenCheckpoints] =
      AwsError.unwrapOptionField(
        "minPauseBetweenCheckpoints",
        minPauseBetweenCheckpoints
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly {
    override val configurationType
        : Optional[zio.aws.kinesisanalyticsv2.model.ConfigurationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationType())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
        )
    override val checkpointingEnabled: Optional[BooleanObject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointingEnabled())
        .map(value => value: BooleanObject)
    override val checkpointInterval: Optional[CheckpointInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.checkpointInterval())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.CheckpointInterval(value)
        )
    override val minPauseBetweenCheckpoints
        : Optional[MinPauseBetweenCheckpoints] = zio.aws.core.internal
      .optionalFromNullable(impl.minPauseBetweenCheckpoints())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .MinPauseBetweenCheckpoints(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
