package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.JobPlanDescription
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FlinkApplicationConfigurationDescription(
    checkpointConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription
    ] = Optional.Absent,
    monitoringConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription
    ] = Optional.Absent,
    parallelismConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription
    ] = Optional.Absent,
    jobPlanDescription: Optional[JobPlanDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription = {
    import FlinkApplicationConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
      .builder()
      .optionallyWith(
        checkpointConfigurationDescription.map(value => value.buildAwsValue())
      )(_.checkpointConfigurationDescription)
      .optionallyWith(
        monitoringConfigurationDescription.map(value => value.buildAwsValue())
      )(_.monitoringConfigurationDescription)
      .optionallyWith(
        parallelismConfigurationDescription.map(value => value.buildAwsValue())
      )(_.parallelismConfigurationDescription)
      .optionallyWith(
        jobPlanDescription.map(value =>
          JobPlanDescription.unwrap(value): java.lang.String
        )
      )(_.jobPlanDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
      .wrap(buildAwsValue())
}
object FlinkApplicationConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription(
        checkpointConfigurationDescription.map(value => value.asEditable),
        monitoringConfigurationDescription.map(value => value.asEditable),
        parallelismConfigurationDescription.map(value => value.asEditable),
        jobPlanDescription.map(value => value)
      )
    def checkpointConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly
    ]
    def monitoringConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly
    ]
    def parallelismConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly
    ]
    def jobPlanDescription: Optional[JobPlanDescription]
    def getCheckpointConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "checkpointConfigurationDescription",
      checkpointConfigurationDescription
    )
    def getMonitoringConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfigurationDescription",
      monitoringConfigurationDescription
    )
    def getParallelismConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "parallelismConfigurationDescription",
      parallelismConfigurationDescription
    )
    def getJobPlanDescription: ZIO[Any, AwsError, JobPlanDescription] =
      AwsError.unwrapOptionField("jobPlanDescription", jobPlanDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly {
    override val checkpointConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.checkpointConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription
          .wrap(value)
      )
    override val monitoringConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription
          .wrap(value)
      )
    override val parallelismConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parallelismConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ParallelismConfigurationDescription
          .wrap(value)
      )
    override val jobPlanDescription: Optional[JobPlanDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobPlanDescription())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives.JobPlanDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
