package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteApplicationCloudWatchLoggingOptionResponse(
    applicationARN: Optional[ResourceARN] = Optional.Absent,
    applicationVersionId: Optional[ApplicationVersionId] = Optional.Absent,
    cloudWatchLoggingOptionDescriptions: Optional[Iterable[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse = {
    import DeleteApplicationCloudWatchLoggingOptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(
        cloudWatchLoggingOptionDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cloudWatchLoggingOptionDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse
      .wrap(buildAwsValue())
}
object DeleteApplicationCloudWatchLoggingOptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse =
      zio.aws.kinesisanalyticsv2.model
        .DeleteApplicationCloudWatchLoggingOptionResponse(
          applicationARN.map(value => value),
          applicationVersionId.map(value => value),
          cloudWatchLoggingOptionDescriptions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def applicationARN: Optional[ResourceARN]
    def applicationVersionId: Optional[ApplicationVersionId]
    def cloudWatchLoggingOptionDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getCloudWatchLoggingOptionDescriptions: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "cloudWatchLoggingOptionDescriptions",
      cloudWatchLoggingOptionDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse
  ) extends zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly {
    override val applicationARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val cloudWatchLoggingOptionDescriptions: Optional[List[
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLoggingOptionDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOptionDescription
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse
  ): zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly =
    new Wrapper(impl)
}
