package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SqlApplicationConfiguration(
    inputs: Optional[Iterable[zio.aws.kinesisanalyticsv2.model.Input]] =
      Optional.Absent,
    outputs: Optional[Iterable[zio.aws.kinesisanalyticsv2.model.Output]] =
      Optional.Absent,
    referenceDataSources: Optional[
      Iterable[zio.aws.kinesisanalyticsv2.model.ReferenceDataSource]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfiguration = {
    import SqlApplicationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfiguration
      .builder()
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        referenceDataSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.referenceDataSources)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration
      .wrap(buildAwsValue())
}
object SqlApplicationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration =
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration(
        inputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        referenceDataSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inputs: Optional[List[zio.aws.kinesisanalyticsv2.model.Input.ReadOnly]]
    def outputs
        : Optional[List[zio.aws.kinesisanalyticsv2.model.Output.ReadOnly]]
    def referenceDataSources: Optional[
      List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly]
    ]
    def getInputs: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.Input.ReadOnly
    ]] = AwsError.unwrapOptionField("inputs", inputs)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.Output.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getReferenceDataSources: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("referenceDataSources", referenceDataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration.ReadOnly {
    override val inputs
        : Optional[List[zio.aws.kinesisanalyticsv2.model.Input.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.Input.wrap(item)
          }.toList
        )
    override val outputs
        : Optional[List[zio.aws.kinesisanalyticsv2.model.Output.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kinesisanalyticsv2.model.Output.wrap(item)
          }.toList
        )
    override val referenceDataSources: Optional[
      List[zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.referenceDataSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.ReferenceDataSource.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlApplicationConfiguration
  ): zio.aws.kinesisanalyticsv2.model.SqlApplicationConfiguration.ReadOnly =
    new Wrapper(impl)
}
