package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ApplicationName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationsResponse(
    applicationSummaries: Iterable[
      zio.aws.kinesisanalyticsv2.model.ApplicationSummary
    ],
    nextToken: Optional[ApplicationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse
      .builder()
      .applicationSummaries(applicationSummaries.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse
      .wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse =
      zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse(
        applicationSummaries.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def applicationSummaries
        : List[zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly]
    def nextToken: Optional[ApplicationName]
    def getApplicationSummaries: ZIO[Any, Nothing, List[
      zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly
    ]] = ZIO.succeed(applicationSummaries)
    def getNextToken: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse
  ) extends zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly {
    override val applicationSummaries
        : List[zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly] =
      impl
        .applicationSummaries()
        .asScala
        .map { item =>
          zio.aws.kinesisanalyticsv2.model.ApplicationSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ApplicationName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationsResponse
  ): zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
