package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisStreamsOutput(resourceARN: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutput = {
    import KinesisStreamsOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutput
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutput.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutput.wrap(buildAwsValue())
}
object KinesisStreamsOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutput =
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutput(resourceARN)
    def resourceARN: ResourceARN
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutput
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutput.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsOutput
  ): zio.aws.kinesisanalyticsv2.model.KinesisStreamsOutput.ReadOnly =
    new Wrapper(impl)
}
