package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisFirehoseInput(resourceARN: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInput = {
    import KinesisFirehoseInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInput
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.wrap(buildAwsValue())
}
object KinesisFirehoseInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput =
      zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput(resourceARN)
    def resourceARN: ResourceARN
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInput
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisFirehoseInput
  ): zio.aws.kinesisanalyticsv2.model.KinesisFirehoseInput.ReadOnly =
    new Wrapper(impl)
}
