package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters._
sealed trait ArtifactType {
  def unwrap
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType
}
object ArtifactType {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType
  ): zio.aws.kinesisanalyticsv2.model.ArtifactType = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType.UDF =>
      val r = UDF
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType.DEPENDENCY_JAR =>
      val r = DEPENDENCY_JAR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType.UNKNOWN_TO_SDK_VERSION
  }
  case object UDF extends zio.aws.kinesisanalyticsv2.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType.UDF
  }
  case object DEPENDENCY_JAR
      extends zio.aws.kinesisanalyticsv2.model.ArtifactType {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ArtifactType.DEPENDENCY_JAR
  }
}
