package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.SnapshotName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationRestoreConfiguration(
    applicationRestoreType: zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType,
    snapshotName: Optional[SnapshotName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreConfiguration = {
    import ApplicationRestoreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
      .builder()
      .applicationRestoreType(applicationRestoreType.unwrap)
      .optionallyWith(
        snapshotName.map(value => SnapshotName.unwrap(value): java.lang.String)
      )(_.snapshotName)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
      .wrap(buildAwsValue())
}
object ApplicationRestoreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration =
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration(
        applicationRestoreType,
        snapshotName.map(value => value)
      )
    def applicationRestoreType
        : zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType
    def snapshotName: Optional[SnapshotName]
    def getApplicationRestoreType: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType
    ] = ZIO.succeed(applicationRestoreType)
    def getSnapshotName: ZIO[Any, AwsError, SnapshotName] =
      AwsError.unwrapOptionField("snapshotName", snapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly {
    override val applicationRestoreType
        : zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType =
      zio.aws.kinesisanalyticsv2.model.ApplicationRestoreType
        .wrap(impl.applicationRestoreType())
    override val snapshotName: Optional[SnapshotName] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotName())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.SnapshotName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationRestoreConfiguration
  ): zio.aws.kinesisanalyticsv2.model.ApplicationRestoreConfiguration.ReadOnly =
    new Wrapper(impl)
}
