package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationMode {
  def unwrap
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode
}
object ApplicationMode {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode
  ): zio.aws.kinesisanalyticsv2.model.ApplicationMode = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode.STREAMING =>
      val r = STREAMING
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode.INTERACTIVE =>
      val r = INTERACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.ApplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode.UNKNOWN_TO_SDK_VERSION
  }
  case object STREAMING
      extends zio.aws.kinesisanalyticsv2.model.ApplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode.STREAMING
  }
  case object INTERACTIVE
      extends zio.aws.kinesisanalyticsv2.model.ApplicationMode {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMode.INTERACTIVE
  }
}
