package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ApplicationCodeConfiguration(
    codeContent: Optional[zio.aws.kinesisanalyticsv2.model.CodeContent] =
      Optional.Absent,
    codeContentType: zio.aws.kinesisanalyticsv2.model.CodeContentType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration = {
    import ApplicationCodeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration
      .builder()
      .optionallyWith(codeContent.map(value => value.buildAwsValue()))(
        _.codeContent
      )
      .codeContentType(codeContentType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration
      .wrap(buildAwsValue())
}
object ApplicationCodeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration =
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration(
        codeContent.map(value => value.asEditable),
        codeContentType
      )
    def codeContent
        : Optional[zio.aws.kinesisanalyticsv2.model.CodeContent.ReadOnly]
    def codeContentType: zio.aws.kinesisanalyticsv2.model.CodeContentType
    def getCodeContent: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CodeContent.ReadOnly
    ] = AwsError.unwrapOptionField("codeContent", codeContent)
    def getCodeContentType
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.CodeContentType] =
      ZIO.succeed(codeContentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration.ReadOnly {
    override val codeContent
        : Optional[zio.aws.kinesisanalyticsv2.model.CodeContent.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeContent())
        .map(value => zio.aws.kinesisanalyticsv2.model.CodeContent.wrap(value))
    override val codeContentType
        : zio.aws.kinesisanalyticsv2.model.CodeContentType =
      zio.aws.kinesisanalyticsv2.model.CodeContentType
        .wrap(impl.codeContentType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationCodeConfiguration
  ): zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfiguration.ReadOnly =
    new Wrapper(impl)
}
