package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.Id
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SqlRunConfiguration(
    inputId: Id,
    inputStartingPositionConfiguration: zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration = {
    import SqlRunConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration
      .builder()
      .inputId(Id.unwrap(inputId): java.lang.String)
      .inputStartingPositionConfiguration(
        inputStartingPositionConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.wrap(buildAwsValue())
}
object SqlRunConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration =
      zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration(
        inputId,
        inputStartingPositionConfiguration.asEditable
      )
    def inputId: Id
    def inputStartingPositionConfiguration
        : zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    def getInputId: ZIO[Any, Nothing, Id] = ZIO.succeed(inputId)
    def getInputStartingPositionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly
    ] = ZIO.succeed(inputStartingPositionConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.ReadOnly {
    override val inputId: Id =
      zio.aws.kinesisanalyticsv2.model.primitives.Id(impl.inputId())
    override val inputStartingPositionConfiguration
        : zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.InputStartingPositionConfiguration
        .wrap(impl.inputStartingPositionConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.SqlRunConfiguration
  ): zio.aws.kinesisanalyticsv2.model.SqlRunConfiguration.ReadOnly =
    new Wrapper(impl)
}
