package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InputProcessingConfigurationDescription(
    inputLambdaProcessorDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription = {
    import InputProcessingConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
      .builder()
      .optionallyWith(
        inputLambdaProcessorDescription.map(value => value.buildAwsValue())
      )(_.inputLambdaProcessorDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
      .wrap(buildAwsValue())
}
object InputProcessingConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription(
        inputLambdaProcessorDescription.map(value => value.asEditable)
      )
    def inputLambdaProcessorDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly
    ]
    def getInputLambdaProcessorDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inputLambdaProcessorDescription",
      inputLambdaProcessorDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly {
    override val inputLambdaProcessorDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputLambdaProcessorDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.InputLambdaProcessorDescription
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.InputProcessingConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.InputProcessingConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
