package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationResponse(
    applicationDetail: zio.aws.kinesisanalyticsv2.model.ApplicationDetail
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse = {
    import DescribeApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse
      .builder()
      .applicationDetail(applicationDetail.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse =
      zio.aws.kinesisanalyticsv2.model
        .DescribeApplicationResponse(applicationDetail.asEditable)
    def applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    def getApplicationDetail: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    ] = ZIO.succeed(applicationDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly {
    override val applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail
        .wrap(impl.applicationDetail())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationResponse
  ): zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
