package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.LogStreamARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CloudWatchLoggingOption(logStreamARN: LogStreamARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption = {
    import CloudWatchLoggingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption
      .builder()
      .logStreamARN(LogStreamARN.unwrap(logStreamARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption
      .wrap(buildAwsValue())
}
object CloudWatchLoggingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption =
      zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption(logStreamARN)
    def logStreamARN: LogStreamARN
    def getLogStreamARN: ZIO[Any, Nothing, LogStreamARN] =
      ZIO.succeed(logStreamARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption
  ) extends zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly {
    override val logStreamARN: LogStreamARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .LogStreamARN(impl.logStreamARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CloudWatchLoggingOption
  ): zio.aws.kinesisanalyticsv2.model.CloudWatchLoggingOption.ReadOnly =
    new Wrapper(impl)
}
