package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ZeppelinMonitoringConfigurationDescription(
    logLevel: Optional[zio.aws.kinesisanalyticsv2.model.LogLevel] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription = {
    import ZeppelinMonitoringConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription
      .builder()
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription
      .wrap(buildAwsValue())
}
object ZeppelinMonitoringConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model
        .ZeppelinMonitoringConfigurationDescription(
          logLevel.map(value => value)
        )
    def logLevel: Optional[zio.aws.kinesisanalyticsv2.model.LogLevel]
    def getLogLevel
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription.ReadOnly {
    override val logLevel: Optional[zio.aws.kinesisanalyticsv2.model.LogLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logLevel())
        .map(value => zio.aws.kinesisanalyticsv2.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
