package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ApplicationName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationVersionRequest(
    applicationName: ApplicationName,
    applicationVersionId: ApplicationVersionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest = {
    import DescribeApplicationVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .applicationVersionId(
        ApplicationVersionId.unwrap(applicationVersionId): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionRequest =
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionRequest(
        applicationName,
        applicationVersionId
      )
    def applicationName: ApplicationName
    def applicationVersionId: ApplicationVersionId
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getApplicationVersionId: ZIO[Any, Nothing, ApplicationVersionId] =
      ZIO.succeed(applicationVersionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val applicationVersionId: ApplicationVersionId =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationVersionId(impl.applicationVersionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationVersionRequest
  ): zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionRequest.ReadOnly =
    new Wrapper(impl)
}
