package zio.aws.kinesisanalyticsv2
import zio.aws.kinesisanalyticsv2.model.{
  UpdateApplicationRequest,
  DeleteApplicationCloudWatchLoggingOptionRequest,
  DeleteApplicationRequest,
  AddApplicationOutputRequest,
  StartApplicationRequest,
  AddApplicationReferenceDataSourceRequest,
  DeleteApplicationSnapshotRequest,
  AddApplicationCloudWatchLoggingOptionRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DiscoverInputSchemaRequest,
  DeleteApplicationInputProcessingConfigurationRequest,
  ListApplicationSnapshotsRequest,
  DeleteApplicationVpcConfigurationRequest,
  DescribeApplicationRequest,
  AddApplicationVpcConfigurationRequest,
  UpdateApplicationMaintenanceConfigurationRequest,
  DescribeApplicationVersionRequest,
  RollbackApplicationRequest,
  DescribeApplicationSnapshotRequest,
  UntagResourceRequest,
  ListApplicationsRequest,
  AddApplicationInputProcessingConfigurationRequest,
  StopApplicationRequest,
  CreateApplicationSnapshotRequest,
  ListApplicationVersionsRequest,
  DeleteApplicationReferenceDataSourceRequest,
  DeleteApplicationOutputRequest,
  CreateApplicationPresignedUrlRequest,
  TagResourceRequest,
  AddApplicationInputRequest
}
import zio.aws.kinesisanalyticsv2.model.TagResourceResponse.ReadOnly
import software.amazon.awssdk.services.kinesisanalyticsv2.KinesisAnalyticsV2AsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object KinesisAnalyticsV2Mock extends Mock[KinesisAnalyticsV2] {
  object DeleteApplicationSnapshot
      extends Effect[
        DeleteApplicationSnapshotRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse.ReadOnly
      ]
  object DeleteApplication
      extends Effect[
        DeleteApplicationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationResponse.ReadOnly
      ]
  object CreateApplicationSnapshot
      extends Effect[
        CreateApplicationSnapshotRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse.ReadOnly
      ]
  object AddApplicationReferenceDataSource
      extends Effect[
        AddApplicationReferenceDataSourceRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly
      ]
  object DescribeApplicationSnapshot
      extends Effect[
        DescribeApplicationSnapshotRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly
      ]
  object CreateApplicationPresignedUrl
      extends Effect[
        CreateApplicationPresignedUrlRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly
      ]
  object DescribeApplication
      extends Effect[
        DescribeApplicationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly
      ]
  object DeleteApplicationOutput
      extends Effect[
        DeleteApplicationOutputRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly
      ]
  object DiscoverInputSchema
      extends Effect[
        DiscoverInputSchemaRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaResponse.ReadOnly
      ]
  object DeleteApplicationInputProcessingConfiguration
      extends Effect[
        DeleteApplicationInputProcessingConfigurationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
      ]
  object AddApplicationCloudWatchLoggingOption
      extends Effect[
        AddApplicationCloudWatchLoggingOptionRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
      ]
  object UpdateApplicationMaintenanceConfiguration
      extends Effect[
        UpdateApplicationMaintenanceConfigurationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly
      ]
  object DeleteApplicationVpcConfiguration
      extends Effect[
        DeleteApplicationVpcConfigurationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly
      ]
  object AddApplicationVpcConfiguration
      extends Effect[
        AddApplicationVpcConfigurationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly
      ]
  object AddApplicationOutput
      extends Effect[
        AddApplicationOutputRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly
      ]
  object StartApplication
      extends Effect[
        StartApplicationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.StartApplicationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteApplicationCloudWatchLoggingOption
      extends Effect[
        DeleteApplicationCloudWatchLoggingOptionRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
      ]
  object DescribeApplicationVersion
      extends Effect[
        DescribeApplicationVersionRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly
      ]
  object AddApplicationInputProcessingConfiguration
      extends Effect[
        AddApplicationInputProcessingConfigurationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.ListTagsForResourceResponse.ReadOnly
      ]
  object AddApplicationInput
      extends Effect[
        AddApplicationInputRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly
      ]
  object ListApplicationSnapshots
      extends Stream[
        ListApplicationSnapshotsRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
      ]
  object ListApplicationSnapshotsPaginated
      extends Effect[
        ListApplicationSnapshotsRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly
      ]
  object ListApplicationVersions
      extends Stream[
        ListApplicationVersionsRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly
      ]
  object ListApplicationVersionsPaginated
      extends Effect[
        ListApplicationVersionsRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly
      ]
  object DeleteApplicationReferenceDataSource
      extends Effect[
        DeleteApplicationReferenceDataSourceRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
      ]
  object StopApplication
      extends Effect[
        StopApplicationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.StopApplicationResponse.ReadOnly
      ]
  object RollbackApplication
      extends Effect[
        RollbackApplicationRequest,
        AwsError,
        zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, KinesisAnalyticsV2] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, KinesisAnalyticsV2] { rts =>
        zio.ZIO.succeed {
          new KinesisAnalyticsV2 {
            val api: KinesisAnalyticsV2AsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): KinesisAnalyticsV2 = this
            def deleteApplicationSnapshot(
                request: DeleteApplicationSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DeleteApplicationSnapshotResponse.ReadOnly
            ] = proxy(DeleteApplicationSnapshot, request)
            def deleteApplication(request: DeleteApplicationRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DeleteApplicationResponse.ReadOnly
            ] = proxy(DeleteApplication, request)
            def createApplicationSnapshot(
                request: CreateApplicationSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.CreateApplicationSnapshotResponse.ReadOnly
            ] = proxy(CreateApplicationSnapshot, request)
            def addApplicationReferenceDataSource(
                request: AddApplicationReferenceDataSourceRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.AddApplicationReferenceDataSourceResponse.ReadOnly
            ] = proxy(AddApplicationReferenceDataSource, request)
            def describeApplicationSnapshot(
                request: DescribeApplicationSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DescribeApplicationSnapshotResponse.ReadOnly
            ] = proxy(DescribeApplicationSnapshot, request)
            def createApplicationPresignedUrl(
                request: CreateApplicationPresignedUrlRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.CreateApplicationPresignedUrlResponse.ReadOnly
            ] = proxy(CreateApplicationPresignedUrl, request)
            def describeApplication(request: DescribeApplicationRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DescribeApplicationResponse.ReadOnly
            ] = proxy(DescribeApplication, request)
            def deleteApplicationOutput(
                request: DeleteApplicationOutputRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DeleteApplicationOutputResponse.ReadOnly
            ] = proxy(DeleteApplicationOutput, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def discoverInputSchema(request: DiscoverInputSchemaRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DiscoverInputSchemaResponse.ReadOnly
            ] = proxy(DiscoverInputSchema, request)
            def deleteApplicationInputProcessingConfiguration(
                request: DeleteApplicationInputProcessingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DeleteApplicationInputProcessingConfigurationResponse.ReadOnly
            ] = proxy(DeleteApplicationInputProcessingConfiguration, request)
            def addApplicationCloudWatchLoggingOption(
                request: AddApplicationCloudWatchLoggingOptionRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.AddApplicationCloudWatchLoggingOptionResponse.ReadOnly
            ] = proxy(AddApplicationCloudWatchLoggingOption, request)
            def updateApplicationMaintenanceConfiguration(
                request: UpdateApplicationMaintenanceConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.UpdateApplicationMaintenanceConfigurationResponse.ReadOnly
            ] = proxy(UpdateApplicationMaintenanceConfiguration, request)
            def deleteApplicationVpcConfiguration(
                request: DeleteApplicationVpcConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DeleteApplicationVpcConfigurationResponse.ReadOnly
            ] = proxy(DeleteApplicationVpcConfiguration, request)
            def addApplicationVpcConfiguration(
                request: AddApplicationVpcConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly
            ] = proxy(AddApplicationVpcConfiguration, request)
            def addApplicationOutput(request: AddApplicationOutputRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.AddApplicationOutputResponse.ReadOnly
            ] = proxy(AddApplicationOutput, request)
            def startApplication(request: StartApplicationRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.StartApplicationResponse.ReadOnly
            ] = proxy(StartApplication, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteApplicationCloudWatchLoggingOption(
                request: DeleteApplicationCloudWatchLoggingOptionRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DeleteApplicationCloudWatchLoggingOptionResponse.ReadOnly
            ] = proxy(DeleteApplicationCloudWatchLoggingOption, request)
            def describeApplicationVersion(
                request: DescribeApplicationVersionRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DescribeApplicationVersionResponse.ReadOnly
            ] = proxy(DescribeApplicationVersion, request)
            def addApplicationInputProcessingConfiguration(
                request: AddApplicationInputProcessingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.AddApplicationInputProcessingConfigurationResponse.ReadOnly
            ] = proxy(AddApplicationInputProcessingConfiguration, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def addApplicationInput(request: AddApplicationInputRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.AddApplicationInputResponse.ReadOnly
            ] = proxy(AddApplicationInput, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kinesisanalyticsv2.model.ApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def listApplicationSnapshots(
                request: ListApplicationSnapshotsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kinesisanalyticsv2.model.SnapshotDetails.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationSnapshots, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationSnapshotsPaginated(
                request: ListApplicationSnapshotsRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsResponse.ReadOnly
            ] = proxy(ListApplicationSnapshotsPaginated, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def listApplicationVersions(
                request: ListApplicationVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kinesisanalyticsv2.model.ApplicationVersionSummary.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplicationVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationVersionsPaginated(
                request: ListApplicationVersionsRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsResponse.ReadOnly
            ] = proxy(ListApplicationVersionsPaginated, request)
            def deleteApplicationReferenceDataSource(
                request: DeleteApplicationReferenceDataSourceRequest
            ): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.DeleteApplicationReferenceDataSourceResponse.ReadOnly
            ] = proxy(DeleteApplicationReferenceDataSource, request)
            def stopApplication(request: StopApplicationRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.StopApplicationResponse.ReadOnly
            ] = proxy(StopApplication, request)
            def rollbackApplication(request: RollbackApplicationRequest): IO[
              AwsError,
              zio.aws.kinesisanalyticsv2.model.RollbackApplicationResponse.ReadOnly
            ] = proxy(RollbackApplication, request)
          }
        }
      }
    }
  }
}
