package zio.aws.kinesisanalyticsv2.model
import scala.jdk.CollectionConverters._
sealed trait SnapshotStatus {
  def unwrap
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus
}
object SnapshotStatus {
  def wrap(
      value: software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus
  ): zio.aws.kinesisanalyticsv2.model.SnapshotStatus = value match {
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kinesisanalyticsv2.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.kinesisanalyticsv2.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.CREATING
  }
  case object READY extends zio.aws.kinesisanalyticsv2.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.READY
  }
  case object DELETING extends zio.aws.kinesisanalyticsv2.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.DELETING
  }
  case object FAILED extends zio.aws.kinesisanalyticsv2.model.SnapshotStatus {
    override def unwrap
        : software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus =
      software.amazon.awssdk.services.kinesisanalyticsv2.model.SnapshotStatus.FAILED
  }
}
