package zio.aws.kinesisanalyticsv2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kinesisanalyticsv2.model.primitives.{
  NextToken,
  ListSnapshotsInputLimit,
  ApplicationName
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListApplicationSnapshotsRequest(
    applicationName: ApplicationName,
    limit: Optional[ListSnapshotsInputLimit] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest = {
    import ListApplicationSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        limit.map(value => ListSnapshotsInputLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
      .wrap(buildAwsValue())
}
object ListApplicationSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest =
      zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest(
        applicationName,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: ApplicationName
    def limit: Optional[ListSnapshotsInputLimit]
    def nextToken: Optional[NextToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getLimit: ZIO[Any, AwsError, ListSnapshotsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
  ) extends zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val limit: Optional[ListSnapshotsInputLimit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.limit())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ListSnapshotsInputLimit(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest
  ): zio.aws.kinesisanalyticsv2.model.ListApplicationSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
