package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    applicationDetail: zio.aws.kinesisanalyticsv2.model.ApplicationDetail
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse
      .builder()
      .applicationDetail(applicationDetail.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse
      .wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse =
      zio.aws.kinesisanalyticsv2.model
        .CreateApplicationResponse(applicationDetail.asEditable)
    def applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    def getApplicationDetail: ZIO[
      Any,
      Nothing,
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly
    ] = ZIO.succeed(applicationDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly {
    override val applicationDetail
        : zio.aws.kinesisanalyticsv2.model.ApplicationDetail.ReadOnly =
      zio.aws.kinesisanalyticsv2.model.ApplicationDetail
        .wrap(impl.applicationDetail())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CreateApplicationResponse
  ): zio.aws.kinesisanalyticsv2.model.CreateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
