package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationVersionId,
  ResourceARN
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddApplicationVpcConfigurationResponse(
    applicationARN: Optional[ResourceARN] = Optional.Absent,
    applicationVersionId: Optional[ApplicationVersionId] = Optional.Absent,
    vpcConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse = {
    import AddApplicationVpcConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
      .builder()
      .optionallyWith(
        applicationARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.applicationARN)
      .optionallyWith(
        applicationVersionId.map(value =>
          ApplicationVersionId.unwrap(value): java.lang.Long
        )
      )(_.applicationVersionId)
      .optionallyWith(
        vpcConfigurationDescription.map(value => value.buildAwsValue())
      )(_.vpcConfigurationDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
      .wrap(buildAwsValue())
}
object AddApplicationVpcConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse =
      zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse(
        applicationARN.map(value => value),
        applicationVersionId.map(value => value),
        vpcConfigurationDescription.map(value => value.asEditable)
      )
    def applicationARN: Optional[ResourceARN]
    def applicationVersionId: Optional[ApplicationVersionId]
    def vpcConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ]
    def getApplicationARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("applicationARN", applicationARN)
    def getApplicationVersionId: ZIO[Any, AwsError, ApplicationVersionId] =
      AwsError.unwrapOptionField("applicationVersionId", applicationVersionId)
    def getVpcConfigurationDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "vpcConfigurationDescription",
      vpcConfigurationDescription
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
  ) extends zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly {
    override val applicationARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationARN())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN(value)
      )
    override val applicationVersionId: Optional[ApplicationVersionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationVersionId())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.primitives
            .ApplicationVersionId(value)
        )
    override val vpcConfigurationDescription: Optional[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcConfigurationDescription())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.VpcConfigurationDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse
  ): zio.aws.kinesisanalyticsv2.model.AddApplicationVpcConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
