package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ApplicationName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StartApplicationRequest(
    applicationName: ApplicationName,
    runConfiguration: Option[
      zio.aws.kinesisanalyticsv2.model.RunConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest = {
    import StartApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(runConfiguration.map(value => value.buildAwsValue()))(
        _.runConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.StartApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.StartApplicationRequest
      .wrap(buildAwsValue())
}
object StartApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.StartApplicationRequest =
      zio.aws.kinesisanalyticsv2.model.StartApplicationRequest(
        applicationName,
        runConfiguration.map(value => value.asEditable)
      )
    def applicationName: ApplicationName
    def runConfiguration
        : Option[zio.aws.kinesisanalyticsv2.model.RunConfiguration.ReadOnly]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getRunConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.RunConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("runConfiguration", runConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.StartApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val runConfiguration
        : Option[zio.aws.kinesisanalyticsv2.model.RunConfiguration.ReadOnly] =
      scala
        .Option(impl.runConfiguration())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.RunConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.StartApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.StartApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
