package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecordFormat(
    recordFormatType: zio.aws.kinesisanalyticsv2.model.RecordFormatType,
    mappingParameters: Option[
      zio.aws.kinesisanalyticsv2.model.MappingParameters
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormat = {
    import RecordFormat.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormat
      .builder()
      .recordFormatType(recordFormatType.unwrap)
      .optionallyWith(mappingParameters.map(value => value.buildAwsValue()))(
        _.mappingParameters
      )
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.RecordFormat.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.RecordFormat.wrap(buildAwsValue())
}
object RecordFormat {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormat
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.RecordFormat =
      zio.aws.kinesisanalyticsv2.model.RecordFormat(
        recordFormatType,
        mappingParameters.map(value => value.asEditable)
      )
    def recordFormatType: zio.aws.kinesisanalyticsv2.model.RecordFormatType
    def mappingParameters
        : Option[zio.aws.kinesisanalyticsv2.model.MappingParameters.ReadOnly]
    def getRecordFormatType
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.RecordFormatType] =
      ZIO.succeed(recordFormatType)
    def getMappingParameters: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MappingParameters.ReadOnly
    ] = AwsError.unwrapOptionField("mappingParameters", mappingParameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormat
  ) extends zio.aws.kinesisanalyticsv2.model.RecordFormat.ReadOnly {
    override val recordFormatType
        : zio.aws.kinesisanalyticsv2.model.RecordFormatType =
      zio.aws.kinesisanalyticsv2.model.RecordFormatType
        .wrap(impl.recordFormatType())
    override val mappingParameters
        : Option[zio.aws.kinesisanalyticsv2.model.MappingParameters.ReadOnly] =
      scala
        .Option(impl.mappingParameters())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.MappingParameters.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.RecordFormat
  ): zio.aws.kinesisanalyticsv2.model.RecordFormat.ReadOnly = new Wrapper(impl)
}
