package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{RoleARN, ResourceARN}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KinesisStreamsInputDescription(
    resourceARN: ResourceARN,
    roleARN: Option[RoleARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputDescription = {
    import KinesisStreamsInputDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputDescription
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription
      .wrap(buildAwsValue())
}
object KinesisStreamsInputDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription =
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription(
        resourceARN,
        roleARN.map(value => value)
      )
    def resourceARN: ResourceARN
    def roleARN: Option[RoleARN]
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputDescription
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
    override val roleARN: Option[RoleARN] = scala
      .Option(impl.roleARN())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.RoleARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInputDescription
  ): zio.aws.kinesisanalyticsv2.model.KinesisStreamsInputDescription.ReadOnly =
    new Wrapper(impl)
}
