package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  BooleanObject,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeApplicationRequest(
    applicationName: ApplicationName,
    includeAdditionalDetails: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest = {
    import DescribeApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        includeAdditionalDetails.map(value => value: java.lang.Boolean)
      )(_.includeAdditionalDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.DescribeApplicationRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.DescribeApplicationRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.DescribeApplicationRequest =
      zio.aws.kinesisanalyticsv2.model.DescribeApplicationRequest(
        applicationName,
        includeAdditionalDetails.map(value => value)
      )
    def applicationName: ApplicationName
    def includeAdditionalDetails: Option[BooleanObject]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getIncludeAdditionalDetails: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField(
        "includeAdditionalDetails",
        includeAdditionalDetails
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest
  ) extends zio.aws.kinesisanalyticsv2.model.DescribeApplicationRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val includeAdditionalDetails: Option[BooleanObject] = scala
      .Option(impl.includeAdditionalDetails())
      .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.DescribeApplicationRequest
  ): zio.aws.kinesisanalyticsv2.model.DescribeApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
