package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ApplicationConfigurationUpdate(
    sqlApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
    ] = None,
    applicationCodeConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
    ] = None,
    flinkApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
    ] = None,
    environmentPropertyUpdates: Option[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates
    ] = None,
    applicationSnapshotConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate
    ] = None,
    vpcConfigurationUpdates: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate]
    ] = None,
    zeppelinApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate = {
    import ApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        sqlApplicationConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.sqlApplicationConfigurationUpdate)
      .optionallyWith(
        applicationCodeConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.applicationCodeConfigurationUpdate)
      .optionallyWith(
        flinkApplicationConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.flinkApplicationConfigurationUpdate)
      .optionallyWith(
        environmentPropertyUpdates.map(value => value.buildAwsValue())
      )(_.environmentPropertyUpdates)
      .optionallyWith(
        applicationSnapshotConfigurationUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.applicationSnapshotConfigurationUpdate)
      .optionallyWith(
        vpcConfigurationUpdates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcConfigurationUpdates)
      .optionallyWith(
        zeppelinApplicationConfigurationUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.zeppelinApplicationConfigurationUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object ApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate(
        sqlApplicationConfigurationUpdate.map(value => value.asEditable),
        applicationCodeConfigurationUpdate.map(value => value.asEditable),
        flinkApplicationConfigurationUpdate.map(value => value.asEditable),
        environmentPropertyUpdates.map(value => value.asEditable),
        applicationSnapshotConfigurationUpdate.map(value => value.asEditable),
        vpcConfigurationUpdates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        zeppelinApplicationConfigurationUpdate.map(value => value.asEditable)
      )
    def sqlApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly
    ]
    def applicationCodeConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly
    ]
    def flinkApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly
    ]
    def environmentPropertyUpdates: Option[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly
    ]
    def applicationSnapshotConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate.ReadOnly
    ]
    def vpcConfigurationUpdates: Option[
      List[zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly]
    ]
    def zeppelinApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly
    ]
    def getSqlApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sqlApplicationConfigurationUpdate",
      sqlApplicationConfigurationUpdate
    )
    def getApplicationCodeConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationCodeConfigurationUpdate",
      applicationCodeConfigurationUpdate
    )
    def getFlinkApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "flinkApplicationConfigurationUpdate",
      flinkApplicationConfigurationUpdate
    )
    def getEnvironmentPropertyUpdates: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly
    ] = AwsError.unwrapOptionField(
      "environmentPropertyUpdates",
      environmentPropertyUpdates
    )
    def getApplicationSnapshotConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationSnapshotConfigurationUpdate",
      applicationSnapshotConfigurationUpdate
    )
    def getVpcConfigurationUpdates: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "vpcConfigurationUpdates",
      vpcConfigurationUpdates
    )
    def getZeppelinApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "zeppelinApplicationConfigurationUpdate",
      zeppelinApplicationConfigurationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly {
    override val sqlApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.sqlApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.SqlApplicationConfigurationUpdate
          .wrap(value)
      )
    override val applicationCodeConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.applicationCodeConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationCodeConfigurationUpdate
          .wrap(value)
      )
    override val flinkApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.flinkApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.FlinkApplicationConfigurationUpdate
          .wrap(value)
      )
    override val environmentPropertyUpdates: Option[
      zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.ReadOnly
    ] = scala
      .Option(impl.environmentPropertyUpdates())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.EnvironmentPropertyUpdates.wrap(value)
      )
    override val applicationSnapshotConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.applicationSnapshotConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ApplicationSnapshotConfigurationUpdate
          .wrap(value)
      )
    override val vpcConfigurationUpdates: Option[
      List[zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.ReadOnly]
    ] = scala
      .Option(impl.vpcConfigurationUpdates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.VpcConfigurationUpdate.wrap(item)
        }.toList
      )
    override val zeppelinApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.zeppelinApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.ApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
