package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{SecurityGroupId, SubnetId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VpcConfiguration(
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Iterable[SecurityGroupId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfiguration = {
    import VpcConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfiguration
      .builder()
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .securityGroupIds(securityGroupIds.map { item =>
        SecurityGroupId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.VpcConfiguration.wrap(buildAwsValue())
}
object VpcConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.VpcConfiguration =
      zio.aws.kinesisanalyticsv2.model
        .VpcConfiguration(subnetIds, securityGroupIds)
    def subnetIds: List[SubnetId]
    def securityGroupIds: List[SecurityGroupId]
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, Nothing, List[SecurityGroupId]] =
      ZIO.succeed(securityGroupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly {
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.kinesisanalyticsv2.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: List[SecurityGroupId] = impl
      .securityGroupIds()
      .asScala
      .map { item =>
        zio.aws.kinesisanalyticsv2.model.primitives.SecurityGroupId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.VpcConfiguration
  ): zio.aws.kinesisanalyticsv2.model.VpcConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
