package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{FileKey, BucketARN}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3ReferenceDataSourceUpdate(
    bucketARNUpdate: Option[BucketARN] = None,
    fileKeyUpdate: Option[FileKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate = {
    import S3ReferenceDataSourceUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate
      .builder()
      .optionallyWith(
        bucketARNUpdate.map(value => BucketARN.unwrap(value): java.lang.String)
      )(_.bucketARNUpdate)
      .optionallyWith(
        fileKeyUpdate.map(value => FileKey.unwrap(value): java.lang.String)
      )(_.fileKeyUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate
      .wrap(buildAwsValue())
}
object S3ReferenceDataSourceUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate =
      zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate(
        bucketARNUpdate.map(value => value),
        fileKeyUpdate.map(value => value)
      )
    def bucketARNUpdate: Option[BucketARN]
    def fileKeyUpdate: Option[FileKey]
    def getBucketARNUpdate: ZIO[Any, AwsError, BucketARN] =
      AwsError.unwrapOptionField("bucketARNUpdate", bucketARNUpdate)
    def getFileKeyUpdate: ZIO[Any, AwsError, FileKey] =
      AwsError.unwrapOptionField("fileKeyUpdate", fileKeyUpdate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate.ReadOnly {
    override val bucketARNUpdate: Option[BucketARN] = scala
      .Option(impl.bucketARNUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.BucketARN(value)
      )
    override val fileKeyUpdate: Option[FileKey] = scala
      .Option(impl.fileKeyUpdate())
      .map(value => zio.aws.kinesisanalyticsv2.model.primitives.FileKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate
  ): zio.aws.kinesisanalyticsv2.model.S3ReferenceDataSourceUpdate.ReadOnly =
    new Wrapper(impl)
}
