package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  ApplicationMaintenanceWindowEndTime,
  ApplicationMaintenanceWindowStartTime
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplicationMaintenanceConfigurationDescription(
    applicationMaintenanceWindowStartTime: ApplicationMaintenanceWindowStartTime,
    applicationMaintenanceWindowEndTime: ApplicationMaintenanceWindowEndTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription = {
    import ApplicationMaintenanceConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
      .builder()
      .applicationMaintenanceWindowStartTime(
        ApplicationMaintenanceWindowStartTime.unwrap(
          applicationMaintenanceWindowStartTime
        ): java.lang.String
      )
      .applicationMaintenanceWindowEndTime(
        ApplicationMaintenanceWindowEndTime.unwrap(
          applicationMaintenanceWindowEndTime
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
      .wrap(buildAwsValue())
}
object ApplicationMaintenanceConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model
        .ApplicationMaintenanceConfigurationDescription(
          applicationMaintenanceWindowStartTime,
          applicationMaintenanceWindowEndTime
        )
    def applicationMaintenanceWindowStartTime
        : ApplicationMaintenanceWindowStartTime
    def applicationMaintenanceWindowEndTime: ApplicationMaintenanceWindowEndTime
    def getApplicationMaintenanceWindowStartTime
        : ZIO[Any, Nothing, ApplicationMaintenanceWindowStartTime] =
      ZIO.succeed(applicationMaintenanceWindowStartTime)
    def getApplicationMaintenanceWindowEndTime
        : ZIO[Any, Nothing, ApplicationMaintenanceWindowEndTime] =
      ZIO.succeed(applicationMaintenanceWindowEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly {
    override val applicationMaintenanceWindowStartTime
        : ApplicationMaintenanceWindowStartTime =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationMaintenanceWindowStartTime(
          impl.applicationMaintenanceWindowStartTime()
        )
    override val applicationMaintenanceWindowEndTime
        : ApplicationMaintenanceWindowEndTime =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationMaintenanceWindowEndTime(
          impl.applicationMaintenanceWindowEndTime()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.ApplicationMaintenanceConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
