package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.ResourceARN
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KinesisStreamsInput(resourceARN: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInput = {
    import KinesisStreamsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInput
      .builder()
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.wrap(buildAwsValue())
}
object KinesisStreamsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput =
      zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput(resourceARN)
    def resourceARN: ResourceARN
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInput
  ) extends zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.ReadOnly {
    override val resourceARN: ResourceARN =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ResourceARN(impl.resourceARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisStreamsInput
  ): zio.aws.kinesisanalyticsv2.model.KinesisStreamsInput.ReadOnly =
    new Wrapper(impl)
}
