package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.BooleanObject
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FlinkRunConfiguration(
    allowNonRestoredState: Option[BooleanObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkRunConfiguration = {
    import FlinkRunConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkRunConfiguration
      .builder()
      .optionallyWith(
        allowNonRestoredState.map(value => value: java.lang.Boolean)
      )(_.allowNonRestoredState)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.wrap(buildAwsValue())
}
object FlinkRunConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkRunConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration =
      zio.aws.kinesisanalyticsv2.model
        .FlinkRunConfiguration(allowNonRestoredState.map(value => value))
    def allowNonRestoredState: Option[BooleanObject]
    def getAllowNonRestoredState: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("allowNonRestoredState", allowNonRestoredState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkRunConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly {
    override val allowNonRestoredState: Option[BooleanObject] = scala
      .Option(impl.allowNonRestoredState())
      .map(value => value: BooleanObject)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.FlinkRunConfiguration
  ): zio.aws.kinesisanalyticsv2.model.FlinkRunConfiguration.ReadOnly =
    new Wrapper(impl)
}
