package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomArtifactConfiguration(
    artifactType: zio.aws.kinesisanalyticsv2.model.ArtifactType,
    s3ContentLocation: Option[
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation
    ] = None,
    mavenReference: Option[zio.aws.kinesisanalyticsv2.model.MavenReference] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration = {
    import CustomArtifactConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration
      .builder()
      .artifactType(artifactType.unwrap)
      .optionallyWith(s3ContentLocation.map(value => value.buildAwsValue()))(
        _.s3ContentLocation
      )
      .optionallyWith(mavenReference.map(value => value.buildAwsValue()))(
        _.mavenReference
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration
      .wrap(buildAwsValue())
}
object CustomArtifactConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration =
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration(
        artifactType,
        s3ContentLocation.map(value => value.asEditable),
        mavenReference.map(value => value.asEditable)
      )
    def artifactType: zio.aws.kinesisanalyticsv2.model.ArtifactType
    def s3ContentLocation
        : Option[zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly]
    def mavenReference
        : Option[zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly]
    def getArtifactType
        : ZIO[Any, Nothing, zio.aws.kinesisanalyticsv2.model.ArtifactType] =
      ZIO.succeed(artifactType)
    def getS3ContentLocation: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly
    ] = AwsError.unwrapOptionField("s3ContentLocation", s3ContentLocation)
    def getMavenReference: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly
    ] = AwsError.unwrapOptionField("mavenReference", mavenReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration
  ) extends zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly {
    override val artifactType: zio.aws.kinesisanalyticsv2.model.ArtifactType =
      zio.aws.kinesisanalyticsv2.model.ArtifactType.wrap(impl.artifactType())
    override val s3ContentLocation
        : Option[zio.aws.kinesisanalyticsv2.model.S3ContentLocation.ReadOnly] =
      scala
        .Option(impl.s3ContentLocation())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.S3ContentLocation.wrap(value)
        )
    override val mavenReference
        : Option[zio.aws.kinesisanalyticsv2.model.MavenReference.ReadOnly] =
      scala
        .Option(impl.mavenReference())
        .map(value =>
          zio.aws.kinesisanalyticsv2.model.MavenReference.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CustomArtifactConfiguration
  ): zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly =
    new Wrapper(impl)
}
