package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  MinPauseBetweenCheckpoints,
  CheckpointInterval,
  BooleanObject
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CheckpointConfigurationDescription(
    configurationType: Option[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = None,
    checkpointingEnabled: Option[BooleanObject] = None,
    checkpointInterval: Option[CheckpointInterval] = None,
    minPauseBetweenCheckpoints: Option[MinPauseBetweenCheckpoints] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription = {
    import CheckpointConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
      .builder()
      .optionallyWith(configurationType.map(value => value.unwrap))(
        _.configurationType
      )
      .optionallyWith(
        checkpointingEnabled.map(value => value: java.lang.Boolean)
      )(_.checkpointingEnabled)
      .optionallyWith(
        checkpointInterval.map(value =>
          CheckpointInterval.unwrap(value): java.lang.Long
        )
      )(_.checkpointInterval)
      .optionallyWith(
        minPauseBetweenCheckpoints.map(value =>
          MinPauseBetweenCheckpoints.unwrap(value): java.lang.Long
        )
      )(_.minPauseBetweenCheckpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription
      .wrap(buildAwsValue())
}
object CheckpointConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription(
        configurationType.map(value => value),
        checkpointingEnabled.map(value => value),
        checkpointInterval.map(value => value),
        minPauseBetweenCheckpoints.map(value => value)
      )
    def configurationType
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def checkpointingEnabled: Option[BooleanObject]
    def checkpointInterval: Option[CheckpointInterval]
    def minPauseBetweenCheckpoints: Option[MinPauseBetweenCheckpoints]
    def getConfigurationType: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField("configurationType", configurationType)
    def getCheckpointingEnabled: ZIO[Any, AwsError, BooleanObject] =
      AwsError.unwrapOptionField("checkpointingEnabled", checkpointingEnabled)
    def getCheckpointInterval: ZIO[Any, AwsError, CheckpointInterval] =
      AwsError.unwrapOptionField("checkpointInterval", checkpointInterval)
    def getMinPauseBetweenCheckpoints
        : ZIO[Any, AwsError, MinPauseBetweenCheckpoints] =
      AwsError.unwrapOptionField(
        "minPauseBetweenCheckpoints",
        minPauseBetweenCheckpoints
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly {
    override val configurationType
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType] = scala
      .Option(impl.configurationType())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
      )
    override val checkpointingEnabled: Option[BooleanObject] = scala
      .Option(impl.checkpointingEnabled())
      .map(value => value: BooleanObject)
    override val checkpointInterval: Option[CheckpointInterval] = scala
      .Option(impl.checkpointInterval())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.CheckpointInterval(value)
      )
    override val minPauseBetweenCheckpoints
        : Option[MinPauseBetweenCheckpoints] = scala
      .Option(impl.minPauseBetweenCheckpoints())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .MinPauseBetweenCheckpoints(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.CheckpointConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.CheckpointConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
