package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MonitoringConfigurationDescription(
    configurationType: Option[
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = None,
    metricsLevel: Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel] = None,
    logLevel: Option[zio.aws.kinesisanalyticsv2.model.LogLevel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationDescription = {
    import MonitoringConfigurationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationDescription
      .builder()
      .optionallyWith(configurationType.map(value => value.unwrap))(
        _.configurationType
      )
      .optionallyWith(metricsLevel.map(value => value.unwrap))(_.metricsLevel)
      .optionallyWith(logLevel.map(value => value.unwrap))(_.logLevel)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription
      .wrap(buildAwsValue())
}
object MonitoringConfigurationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription =
      zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription(
        configurationType.map(value => value),
        metricsLevel.map(value => value),
        logLevel.map(value => value)
      )
    def configurationType
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType]
    def metricsLevel: Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel]
    def logLevel: Option[zio.aws.kinesisanalyticsv2.model.LogLevel]
    def getConfigurationType: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ConfigurationType
    ] = AwsError.unwrapOptionField("configurationType", configurationType)
    def getMetricsLevel
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.MetricsLevel] =
      AwsError.unwrapOptionField("metricsLevel", metricsLevel)
    def getLogLevel
        : ZIO[Any, AwsError, zio.aws.kinesisanalyticsv2.model.LogLevel] =
      AwsError.unwrapOptionField("logLevel", logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationDescription
  ) extends zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly {
    override val configurationType
        : Option[zio.aws.kinesisanalyticsv2.model.ConfigurationType] = scala
      .Option(impl.configurationType())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ConfigurationType.wrap(value)
      )
    override val metricsLevel
        : Option[zio.aws.kinesisanalyticsv2.model.MetricsLevel] = scala
      .Option(impl.metricsLevel())
      .map(value => zio.aws.kinesisanalyticsv2.model.MetricsLevel.wrap(value))
    override val logLevel: Option[zio.aws.kinesisanalyticsv2.model.LogLevel] =
      scala
        .Option(impl.logLevel())
        .map(value => zio.aws.kinesisanalyticsv2.model.LogLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.MonitoringConfigurationDescription
  ): zio.aws.kinesisanalyticsv2.model.MonitoringConfigurationDescription.ReadOnly =
    new Wrapper(impl)
}
