package zio.aws.kinesisanalyticsv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kinesisanalyticsv2.model.primitives.{
  NextToken,
  ListApplicationVersionsInputLimit,
  ApplicationName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListApplicationVersionsRequest(
    applicationName: ApplicationName,
    limit: Option[ListApplicationVersionsInputLimit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest = {
    import ListApplicationVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .optionallyWith(
        limit.map(value =>
          ListApplicationVersionsInputLimit.unwrap(value): Integer
        )
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsRequest.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsRequest
      .wrap(buildAwsValue())
}
object ListApplicationVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsRequest =
      zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsRequest(
        applicationName,
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def applicationName: ApplicationName
    def limit: Option[ListApplicationVersionsInputLimit]
    def nextToken: Option[NextToken]
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getLimit: ZIO[Any, AwsError, ListApplicationVersionsInputLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest
  ) extends zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.kinesisanalyticsv2.model.primitives
        .ApplicationName(impl.applicationName())
    override val limit: Option[ListApplicationVersionsInputLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives
          .ListApplicationVersionsInputLimit(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ListApplicationVersionsRequest
  ): zio.aws.kinesisanalyticsv2.model.ListApplicationVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
