package zio.aws.kinesisanalyticsv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ZeppelinApplicationConfigurationUpdate(
    monitoringConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate
    ] = None,
    catalogConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate
    ] = None,
    deployAsApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
    ] = None,
    customArtifactsConfigurationUpdate: Option[
      Iterable[zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate = {
    import ZeppelinApplicationConfigurationUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
      .builder()
      .optionallyWith(
        monitoringConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.monitoringConfigurationUpdate)
      .optionallyWith(
        catalogConfigurationUpdate.map(value => value.buildAwsValue())
      )(_.catalogConfigurationUpdate)
      .optionallyWith(
        deployAsApplicationConfigurationUpdate.map(value =>
          value.buildAwsValue()
        )
      )(_.deployAsApplicationConfigurationUpdate)
      .optionallyWith(
        customArtifactsConfigurationUpdate.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customArtifactsConfigurationUpdate)
      .build()
  }
  def asReadOnly
      : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly =
    zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
      .wrap(buildAwsValue())
}
object ZeppelinApplicationConfigurationUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate =
      zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate(
        monitoringConfigurationUpdate.map(value => value.asEditable),
        catalogConfigurationUpdate.map(value => value.asEditable),
        deployAsApplicationConfigurationUpdate.map(value => value.asEditable),
        customArtifactsConfigurationUpdate.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def monitoringConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate.ReadOnly
    ]
    def catalogConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.ReadOnly
    ]
    def deployAsApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly
    ]
    def customArtifactsConfigurationUpdate: Option[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]]
    def getMonitoringConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "monitoringConfigurationUpdate",
      monitoringConfigurationUpdate
    )
    def getCatalogConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "catalogConfigurationUpdate",
      catalogConfigurationUpdate
    )
    def getDeployAsApplicationConfigurationUpdate: ZIO[
      Any,
      AwsError,
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deployAsApplicationConfigurationUpdate",
      deployAsApplicationConfigurationUpdate
    )
    def getCustomArtifactsConfigurationUpdate: ZIO[Any, AwsError, List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customArtifactsConfigurationUpdate",
      customArtifactsConfigurationUpdate
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
  ) extends zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly {
    override val monitoringConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.monitoringConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.ZeppelinMonitoringConfigurationUpdate
          .wrap(value)
      )
    override val catalogConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.catalogConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.CatalogConfigurationUpdate.wrap(value)
      )
    override val deployAsApplicationConfigurationUpdate: Option[
      zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate.ReadOnly
    ] = scala
      .Option(impl.deployAsApplicationConfigurationUpdate())
      .map(value =>
        zio.aws.kinesisanalyticsv2.model.DeployAsApplicationConfigurationUpdate
          .wrap(value)
      )
    override val customArtifactsConfigurationUpdate: Option[List[
      zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration.ReadOnly
    ]] = scala
      .Option(impl.customArtifactsConfigurationUpdate())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kinesisanalyticsv2.model.CustomArtifactConfiguration
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate
  ): zio.aws.kinesisanalyticsv2.model.ZeppelinApplicationConfigurationUpdate.ReadOnly =
    new Wrapper(impl)
}
